// Description: a value node that computes the quotient of its children
//
//<b>notes:</b>
//<ul>
//<li> derived nodes inherit all messages from their base classes
//<li> see reset method for default settings
//<li> all children must be value nodes
//<li> child value nodes of any size can be used
//<li> see the <a href="value.html">value</a> node for more information
//</ul>
//
// Category: Math
// Author: Alex Hill
// Revision: 11/01/01
//
#include "divide.h"

extern "C" ygNode* construct_divide(const char* name,bool master) { return new divide(name,master); }

divide::divide(const char* name,bool master) : value(name,master)
	{
	setClassName("divide");
	}

void divide::app(void)
	{
	//if this node has size greater than zero
	if (size > 0)
		{
		int currNumChildren = numChildren();
		//for each child node do
		for (int i=0;i<currNumChildren;i++)
			{
			if (child(i) && child(i)->isOfClass("value"))
				{
				value* currChild = (value*)child(i);
				//get the size of the child node
				int currSize = currChild->getSize();
				//for each value in the child node do
				for (int j=0;j<currSize;j++)
					{
					//if the element is less than the size of this node then
					if (j < size)
						{
						//if the first child, initialize the element value
						if (i == 0)
							values[j] = currChild->getValue(j);
						//else, divide the element value by the child value
						else
							values[j] /= currChild->getValue(j);
						}
					}
				}
			}
		}
	value::app();
	}
