// Description: a node that generates the distance to a node
//
//<b>notes:</b>
//<ul>
//<li> derived nodes inherit all messages from their base classes
//<li> see reset method for default settings
//<li> see the <a href="interpolate">interpolate</a> node for more information
//</ul>
//
// Category: Math
// Author: Alex Hill
// Revision: 11/01/01
//
#include <Performer/pf/pfGroup.h>
#include <ygWorld.h>
#include <ygUser.h>
#include <ygNodeDB.h>
#include "distance.h"

extern "C" ygNode* construct_distance(const char* name,bool master) { return new distance_(name,master); }

distance_::distance_(const char* name,bool master) : interpolate(name,master)
	{
	setClassName("distance");
	setPfNode(new pfGroup);
	node = NULL;
	}

distance_::~distance_(void)
	{
	}

void distance_::reset(void)
	{
	//clear node name
	node = NULL;
	interpolate::reset();
	}

void distance_::message(const ygMessage& msg)
	{
	//clear or set the node and optional user body part
	if (msg == "node")
		{
		//if number of arguments is greater than zero
		if (msg.args.size() > 0)
			{
			node = ygNodeDB::find(msg.args[0]);
			//if node type is user then
			if (msg.args.size() > 1 && node && node->isOfClass("ygUser"))
				{
				ygUser* user = (ygUser*)node;
				//if second argument is "head"
				if (msg.args[1] == "head")
					{
					//set node to user head
					if (user->head())
						node = user->head();
					}
				//if second argument is "body"
				else if (msg.args[1] == "body")
					{
					//for each user child
					for (int i=0; i<user->numChildren(); i++)
						{
						ygNode* currNode = user->child(i);
						//if child is of type body then set node
						if (currNode->isOfClass("body"))
							node = currNode;
						}
					}
				//if second argument is "wand"
				else if (msg.args[1] == "wand")
					{
					//if user has a wand then
					if (user->wand(0))
						{
						//use specified wand number or default to zero
						if (msg.args.size() > 2)
							node = user->wand(msg.intArg(1));
						else
							node = user->wand(0);
						}
					}
				else
					node = user;
				}
			}
		//else, clear the node name
		else
			node = NULL;
		}
	else
		interpolate::message(msg);
	}

void distance_::app(void)
	{
	//if node is set
	if (node)
		{
		//calculate user distance
		pfVec3 pos;
		pos = node->origin(this);
		float distance_;
		distance_ = pos.length();
		//calculate interpolated array values
		for (int i=0;i<size;i++)
			values[i] = startValues[i] + distance_*(endValues[i]-startValues[i]);
		}
	interpolate::app();
	}
