// Description: a value node that computes the current time
//
//<b>notes:</b>
//<ul>
//<li> derived nodes inherit all messages from their base classes
//<li> see reset method for default settings
//<li> the array size is 6 with the following values
//<ul>
//<li> value0 is the seconds after the minute [0,59]
//<li> value1 is the minutes after the hour [0,59]
//<li> value2 is the hour since midnight [0,23]
//<li> value3 is the day of the month [0,31]
//<li> value4 is the months since January [0,11]
//<li> value5 is the years since 1900
//<li> value6 is the days since Sunday [0,6]
//<li> value7 is the days since January 1 [0,365]
//<li> value8 is the daylight savings flag [0:1]
//</ul>
//<li> see the <a href="value.html">value</a> node for more information
//</ul>
//
// Category: Math
// Author: Alex Hill
// Revision: 05/01/03
//
#include "clock.h"
#include <sys/time.h>

extern "C" ygNode* construct_clock(const char* name,bool master) { return new clock_(name,master); }

clock_::clock_(const char* name,bool master) : value(name,master)
	{
	setClassName("clock");
	}

void clock_::reset(void)
	{
	value::reset();
	//set array size to 9
	setValueSize(9);
	//set integer flag to true
	integer = true;
	}

void clock_::app(void)
	{
	struct timeval t;
	gettimeofday(&t,NULL);
	struct tm* local;
	local = localtime(&t.tv_sec);
	if (size == 9)
		{
		values[0] = local->tm_sec;
		values[1] = local->tm_min;
		values[2] = local->tm_hour;
		values[3] = local->tm_mday;
		values[4] = local->tm_mon;
		values[5] = local->tm_year;
		values[6] = local->tm_wday;
		values[7] = local->tm_yday;
		values[8] = local->tm_isdst;
		}
	value::app();
	}
