// Description: a variable size array of boolean values
//
//<b>notes:</b>
//<ul>
//<li> derived nodes inherit all messages from their base classes
//<li> see reset method for default settings
//<li> this node generates an event when any one of the array values changes
//<li> the reference message is used to reference other value nodes
//</ul>
//
// Category: Math
// Author: Alex Hill
// Revision: 11/01/01
//
#include "ygNodeDB.h"
#include "boolean.h"

extern "C" ygNode* construct_boolean(const char* name,bool master) { return new boolean(name,master); }

boolean::boolean(const char* name,bool master) : value(name,master)
	{
	setClassName("boolean");
	}

void boolean::reset(void)
	{
	value::reset();
	integer = true;
	}

void boolean::message(const ygMessage& msg)
	{
	//make this node an instance of another node
	if (msg == "reference")
		{
		if (msg.args.size() > 0 && className() == "boolean")
			{
			ygNode* node = ygNodeDB::find(msg.args[0]);
			if (node && node->isOfClass("value"))
				reference = (value*)node;
			else
				reference = NULL;
			}
		else
			reference = NULL;
		}
	//else, if referenced, send the message to the reference node
	else if (reference)
		{
		reference->message(msg);
		}
	//set the value of a single array element
	else if (msg == "set" || msg == "value")
		{
		if (msg.args.size() > 0)
			{
			float newValue = (float)msg.boolArg(0);
			if (msg.args.size() > 1) 
				{
				int element = msg.intArg(1);
				if (element >= 0)
					{	
					if (element >= size)
						setValueSize(element+1);
					values[element] = newValue;
					}
				else
					msg.error(name(),"(index out of range)");
				}
			else
				{
				if (size > 0)
					values[0] = newValue;
				}
			}
		else
			msg.error(name(),"(wrong number of arguments)");
		}
	//set the values of all array elements
	else if (msg == "values")
		{
		if (msg.args.size() > 0)
			{
			int newSize = msg.args.size();
			if (newSize >= 0)
				{
				setValueSize(newSize);
				for (int i=0;i<size;i++)
					values[i] = (float)msg.boolArg(i);
				}
			else
				msg.error(name(),"(index out of range)");
			}
		else
			msg.error(name(),"(wrong number of arguments)");
		}
	//set all or a single element to true (1.0)
	else if (msg == "true")
		{
		if (msg.args.size() > 0)
			{
			int element = msg.intArg(0);
			if (element >= 0 && element < size)
				values[element] = 1.0;
			else
				msg.error(name(),"(index out of range)");
			}
		else
			{
			for (int i=0;i<size;i++)
				values[i] = 1.0;
			}
		}
	//set all or a single element to false (0.0)
	else if (msg == "false")
		{
		if (msg.args.size() > 0)
			{
			int element = msg.intArg(0);
			if (element >= 0 && element < size)
				values[element] = 0.0;
			else
				msg.error(name(),"(index out of range)");
			}
		else
			{
			for (int i=0;i<size;i++)
				values[i] = 0.0;
			}
		}
	//toggle all or a single element
	else if (msg == "toggle")
		{
		if (msg.args.size() > 0)
			{
			int element = msg.intArg(0);
			if (element >= 0 && element < size)
				{
				if (values[element] == 1.0)
					values[element] = 0.0;
				else
					values[element] = 1.0;
				}
			else
				msg.error(name(),"(index out of range)");
			}
		else
			{
			for (int i=0;i<size;i++)
				{
				if (values[i] == 1.0)
					values[i] = 0.0;
				else
					values[i] = 1.0;
				}
			}
		}
	else
		value::message(msg);
	}

void boolean::app(void)
	{
	bool changedTrue = false;
	bool changedFalse = false;
	//for each value in the array
	for (int i=0;i<size;i++)
		{
		if (values[i] != lastValues[i])
			{
			if (values[i] == 0.0)
				changedFalse = true;
			else
				changedTrue = true;	
			}
		}
	if (changedTrue)
		{
		//any elements turned true
		eventOccurred("changedTrue");
		}
	if (changedFalse)
		{
		//any elements turned false
		eventOccurred("changedFalse");
		}
	value::app();
	}

