// Description: a transform that is a fixed distance below the head of the user
//
//<b>notes:</b>
//<ul>
//<li> derived nodes inherit all messages from their base classes
//<li> see reset method for default settings
//</ul>
//
// Category: User
// Author: Alex Hill
// Revision: 11/01/01
//
#include "body.h"

extern "C" ygNode* construct_body(const char* name,bool master) { return new body(name,master); }

body::body(const char* name,bool master) : ygSimpleTransform(name,master)
	{
	setClassName("body");
	user = NULL;
	}


void body::reset(void)
	{
	//find the user above this node
	user = ygUser::findUserAncestor(this);
	//set the depth to 3.0
	depth = 3.0;
	}


void body::message(const ygMessage& msg)
	{
	//set the depth of the body below the head
	if (msg == "depth")
		{
		if (msg.args.size() > 0)
			depth = msg.floatArg(0);
		else
			msg.error(name(),"(wrong number of arguments)");
		}
	else
		ygSimpleTransform::message(msg);
	}


body::~body(void)
	{
	}

void body::app(void)
	{
	//if a user and a CAVEhead exists
	if ((user) && (user->head()))
		{
		//set the position of the body depth below
		pfVec3 pos;
		pos = user->head()->origin(parent());
		pos[PF_Z] -= depth;
		setPosition(pos);
		}
	ygSimpleTransform::app();
	}
