#ifndef _applyTexture_h_
#define _applyTexture_h_

#include <Performer/pr/pfTexture.h>
#include "ygNode.h"

typedef struct _applyData applyData_t;

class applyTexture : public ygNode
	{
	public:
	 applyTexture(const char* name,bool master=true);
	 ~applyTexture(void);
	 virtual void reset(void);
	 virtual void message(const ygMessage&);
	 virtual void app(void);
	 static int applyPreDraw(pfTraverser*,void *data);
	protected:
	 virtual void acceptNetKey(const ygString&);
	private:
	 applyData_t* data_;
	 unsigned char* destImage;
	 unsigned char* srceImage;
	 pfVec2 position;
	 pfTexture* texture;
	 pfTexture* subtexture;
	 pfGeoState* gstate;
	 ygString filename;
	 int destXSize;
	 int destYSize;
	 int srceXSize;
	 int srceYSize;
	 int destNumComp;
	 int srceNumComp;
	 bool blend;
	 int threshold;
	 void setChildrenTextures(pfNode*);
	 void setGeosetTexture(pfGeoSet*);
	 void loadFile(const ygString&);
	 void apply(const pfVec2&);
	 void restore(void);
	};


#endif
