// Description: a boolean node that computes the AND of its children
//
//<b>notes:</b>
//<ul>
//<li> derived nodes inherit all messages from their base classes
//<li> see reset method for default settings
//<li> all children must be value nodes
//<li> child value nodes of any size can be used
//<li> see the <a href="value.html">value</a> node for more information
//</ul>
//
// Category: Math
// Author: Alex Hill
// Revision: 11/01/01
//
#include "and.h"

extern "C" ygNode* construct_and(const char* name,bool master) { return new and(name,master); }

and::and(const char* name,bool master) : boolean(name,master)
	{
	setClassName("and");
	}

void and::app(void)
	{
	//if this node has size greater than zero
	if (size > 0)
		{
		int currNumChildren = numChildren();
		//for each child node do
		for (int i=0;i<currNumChildren;i++)
			{
			if (child(i) && child(i)->isOfClass("value"))
				{
				value* currChild = (value*)child(i);
				//get the size of the child node
				int currSize = currChild->getSize();
				//for each value in the child node do
				for (int j=0;j<currSize;j++)
					{
					//if the element is less than the size of this node then
					if (j < size)
						{
						//if the first child, initialize the element value to TRUE
						if (i == 0)
							values[j] = 1.0;
						//set the element value to FALSE if the child value is not TRUE
						if (currChild->getValue(j) != 1.0)
							values[j] = 0.0;
						}
					}
				}
			}
		}
	boolean::app();
	}
