
#ifndef _MoviePlayer_h_
#define _MoviePlayer_h_

#include <string.h>
#include <math.h>
#include <time.h>
#include <stdio.h>

#ifdef __cplusplus
extern "C" {
#endif       

#define XINE_ENABLE_EXPERIMENTAL_FEATURES
#define this thiiis
#include <xine.h>
//#include <xine/xineutils.h>
#undef this

#ifdef __cplusplus
}
#endif
          
   
class MoviePlayer {

	public:
		MoviePlayer();
		virtual ~MoviePlayer();

      int open(char *moviefile);
	   int play(int start_pos=0, int start_time=0);
     
      int stop();
    
      int close(); 
      
      int app();
     
      unsigned char *getFrame() { return rgb; } 
      int getWidth() { return width; }
      int getHeight() { return height; }
      
	protected:


	private:
	   void event_listener(void *user_data, const xine_event_t *event);
      

		xine_t              *xine;
		xine_stream_t       *stream;
		xine_video_port_t   *vo_port;
		xine_audio_port_t   *ao_port;
		xine_event_queue_t  *event_queue;
		xine_video_frame_t  *vo_frame_ptr;
		xine_audio_frame_t  *ao_frame_ptr;	

		int running;
		int width, height;

		unsigned char *rgb;

		xine_audio_frame_t ao_frame;
	   xine_video_frame_t vo_frame;
		struct timeval starttime, currtime;
	
      int64_t start_vpts;         
};



#endif

