
#ifndef _JPEG_DECOMPRESS_H_
#define _JPEG_DECOMPRESS_H_

#include <string.h>
#include <stdlib.h>
#include <stdio.h>

#include <jpeglib.h>
#include <jerror.h>


#define INPUT_BUF_SIZE 4096

typedef struct {
   struct jpeg_source_mgr pub; 
   unsigned char *infile; 
   JOCTET *buffer;         
   int numbytes;            
   int offset;
   int error;               
} my_source_mgr;

typedef my_source_mgr * my_src_ptr;



class JPEGDecompress {
   public:
      JPEGDecompress();
      ~JPEGDecompress();
       
      int init();
      int decompress(unsigned char *cimg, int numbytes);

      int getWidth() { return m_Width; }
      int getHeight() { return m_Height; }
      unsigned char *data() { return m_dImg; }
   
   private:

      
      unsigned char *m_dImg;

     
      int m_Width;
      int m_Height;

      int m_Size;
     
      struct jpeg_decompress_struct m_cinfo;
      struct jpeg_error_mgr m_jerr;      

      
      void destroy();
      int jpeg_decompressInit();
};




#endif

