// Revision: 02/24/03 Kalle Jalkanen and Jonas Westling, Interactive Institute Ume, Sweden

#include "JPEGDecompress.h"

#ifdef __cplusplus
extern "C" {
#endif


	
static void init_source(j_decompress_ptr cinfo);
static boolean fill_input_buffer(j_decompress_ptr cinfo);
static void skip_input_data(j_decompress_ptr cinfo, long num_bytes);
static void term_source(j_decompress_ptr cinfo);

#ifdef __cplusplus
}
#endif


JPEGDecompress::JPEGDecompress()
{
	m_Width = 0;
	m_Height = 0;
	m_Size = 0;
	m_dImg = NULL;
	m_cinfo.src = NULL;
}


JPEGDecompress::~JPEGDecompress()
{
	destroy();
}


void JPEGDecompress::destroy()
{
	if (m_cinfo.src) jpeg_destroy_decompress(&m_cinfo);
	if (m_dImg) { delete [] m_dImg; m_dImg = NULL; }
}


int JPEGDecompress::jpeg_decompressInit()
{
	j_decompress_ptr cinfoPtr = &m_cinfo;

	cinfoPtr->err = jpeg_std_error(&m_jerr);
	jpeg_create_decompress(cinfoPtr);

	cinfoPtr->src = (struct jpeg_source_mgr *)
		(*cinfoPtr->mem->alloc_small)
		((j_common_ptr)cinfoPtr, JPOOL_PERMANENT, 
		 sizeof(my_source_mgr));

	my_src_ptr src = (my_src_ptr)cinfoPtr->src;	 
	if (!src) { 
		fprintf(stderr, "ERROR: failed to allocate buffer\n");	
		return 1;
	}	

	src->buffer = (JOCTET *)(*cinfoPtr->mem->alloc_small)
		((j_common_ptr)cinfoPtr, JPOOL_PERMANENT,		
		 INPUT_BUF_SIZE * sizeof(JOCTET));

	if (!src->buffer) {
		fprintf(stderr, "ERROR: failed to allocate buffer\n");
		return 1;
	}

	src->pub.init_source = init_source;
	src->pub.fill_input_buffer = fill_input_buffer;
	src->pub.skip_input_data = skip_input_data;
	src->pub.resync_to_restart = jpeg_resync_to_restart; /* use default method */
	src->pub.term_source = term_source;

	return 0;
}


int JPEGDecompress::init()
{
	destroy();

	if (jpeg_decompressInit() > 0) return 1;

	return 0; 
}


int JPEGDecompress::decompress(unsigned char *cimg, int numbytes)
{
	JSAMPROW row_pointer[1];
	int row_stride;
	
	my_src_ptr src = (my_src_ptr)m_cinfo.src;
	
	src->infile = cimg;
	src->pub.bytes_in_buffer = 0; /* forces fill_input_buffer on first read */
	src->pub.next_input_byte = NULL; /* until buffer loaded */
	src->numbytes = numbytes;
	src->offset = 0;
	
	jpeg_read_header(&m_cinfo, TRUE);
	
	m_Width = m_cinfo.image_width;
	m_Height = m_cinfo.image_height;	
		
	if (!m_dImg) {
		// First time here after a call to init. 
		m_Size = m_Width * m_Height * m_cinfo.num_components;
		m_dImg = new unsigned char[m_Size];
	} else {
		if (m_Size != (m_Width * m_Height * m_cinfo.num_components)) {
			// Image size has changed... we must allocate a new buffer
			m_Size = m_Width * m_Height * m_cinfo.num_components;
			delete [] m_dImg;	
			m_dImg = new unsigned char[m_Size];
		}
	}
	
	m_cinfo.out_color_space = JCS_RGB;
	
	jpeg_start_decompress(&m_cinfo);
	row_stride = m_cinfo.image_width * 3;

	while (m_cinfo.output_scanline < m_cinfo.output_height) {
		row_pointer[0] = m_dImg + (m_cinfo.output_scanline * row_stride);
		jpeg_read_scanlines(&m_cinfo, row_pointer, 1);
	}
		
	jpeg_finish_decompress(&m_cinfo);

	return 0;
}

#ifdef __cplusplus
extern "C" {
#endif

	
static void init_source(j_decompress_ptr cinfo)
{
	my_src_ptr src = (my_src_ptr) cinfo->src;

	src->pub.next_input_byte = NULL;
	src->pub.bytes_in_buffer = 0;
	src->offset = 0;
}



static boolean fill_input_buffer(j_decompress_ptr cinfo)
{
	my_src_ptr src = (my_src_ptr)cinfo->src;
	size_t nbytes = INPUT_BUF_SIZE;

	if (src->numbytes < INPUT_BUF_SIZE) 
		nbytes = src->numbytes;

	if (nbytes <= 0) {
	
		WARNMS(cinfo, JWRN_JPEG_EOF);
		// Insert a fake EOI marker 
		src->buffer[0] = (JOCTET) 0xFF;
		src->buffer[1] = (JOCTET) JPEG_EOI;
		nbytes = 2;
	
	} else {
		
		memcpy(src->buffer, src->infile + src->offset, nbytes);
		src->numbytes -= nbytes;
		src->offset += nbytes;
	}
	
	src->pub.next_input_byte = src->buffer;
	src->pub.bytes_in_buffer = nbytes;

	return TRUE;
}


static void skip_input_data(j_decompress_ptr cinfo, long num_bytes)
{
 	my_src_ptr src = (my_src_ptr) cinfo->src;

  /* Just a dumb implementation for now.  Could use fseek() except
   * it doesn't work on pipes.  Not clear that being smart is worth
   * any trouble anyway --- large skips are infrequent.
   */
  if (num_bytes > 0) {
    while (num_bytes > (long) src->pub.bytes_in_buffer) {
      num_bytes -= (long) src->pub.bytes_in_buffer;
      (void) fill_input_buffer(cinfo);
      /* note we assume that fill_input_buffer will never return FALSE,
       * so suspension need not be handled.
       */
    }
    src->pub.next_input_byte += (size_t) num_bytes;
    src->pub.bytes_in_buffer -= (size_t) num_bytes;
	 src->numbytes -= num_bytes;
	 src->offset += num_bytes;
	}
}


static void term_source(j_decompress_ptr cinfo)
{
	// a no-op
}



#ifdef __cplusplus
}
#endif



