#include <malloc.h>

#ifdef __sgi

#include <dmedia/moviefile.h>

class movieObject
	{
	public:
	 movieObject(void);
	 ~movieObject(void);
	 void open(const ygString&);
	 void close(void);
	 bool getFrame(int,unsigned char*);
	 bool isOpen(void);
	 int getWidth(void);
	 int getHeight(void);
	 int getLength(void);
	 int getRate(void);
	private:
	 MVid movie;
	 MVid track;
	 int length;
	 int width;
	 int height;
	 int rate;
	 unsigned char *yuv[3]; 
	};
	
movieObject::movieObject(void)
	{
	movie = NULL;
	track = NULL;
	length = 0;
	width = 0;
	height = 0;
	rate = 0;
	}
	
movieObject::~movieObject(void)
	{
	close();
	}

void movieObject::open(const ygString& file)
	{
	close();
	mvOpenFile(file.c_str(),O_RDONLY,&movie);
	mvFindTrackByMedium(movie,DM_IMAGE,&track);
	if (movie && track)
		{
		width = mvGetImageWidth(track);
		height = mvGetImageHeight(track);
		rate = mvGetImageRate(track);
		length = (int)mvGetTrackDuration(track,rate);
		yuv[0] = (unsigned char*)malloc(width*height*sizeof(unsigned char));
		yuv[1] = (unsigned char*)malloc((width/2)*(height/2)*sizeof(unsigned char));
		yuv[2] = (unsigned char*)malloc((width/2)*(height/2)*sizeof(unsigned char));
		}
	}

void movieObject::close(void)
	{
	if (movie)
		mvClose(movie);
	movie = NULL;
	}

bool movieObject::getFrame(int frame,unsigned char* buffer)
	{
	if (movie && frame < length)
		{
		mvReadFrames(track,frame,1,width*height*sizeof(unsigned char),buffer);
		return true;
		}
	return false;
	}
	
#else	
	
#include <openquicktime/openquicktime.h>
#include <openquicktime/colormodels.h>
#include <GL/glext.h>

class movieObject
	{
	public:
	 movieObject(void);
	 ~movieObject(void);
	 void open(const ygString&);
	 void close(void);
	 bool getFrame(int,unsigned char*);
	 bool isOpen(void);
	 int getWidth(void);
	 int getHeight(void);
	 int getLength(void);
	 int getRate(void);
	 void setLoop(bool);
	 void setChromaKey(bool);
	 void setChromaKeyColor(double r,double g,double b);
	 void setChromaKeyTolerance(double t);
	 void setChromaKeyFuzziness(double f);
	 double chromaKey(double r,double g,double b);
	private:
	 oqt_t* movie;
	 int length;
	 int width;
	 int height;
	 int rate;
	 bool loop;
	 double chromaKeyTolerance;
	 double chromaKeyFuzziness;
	 double chromaKeyColor[3];
	 unsigned char *yuv[3]; 
	 bool useChromaKey;
	};
	
movieObject::movieObject(void)
	{
	movie = NULL;
	length = 0;
	width = 0;
	height = 0;
	rate = 0;
	useChromaKey = false;
	chromaKeyTolerance=10.0;
	chromaKeyFuzziness=10.0;
	chromaKeyColor[0]=0.0;
	chromaKeyColor[1]=0.0;
	chromaKeyColor[2]=0.0;
	}
	
movieObject::~movieObject(void)
	{
	close();
	}

void movieObject::setChromaKey(bool k)
	{
	useChromaKey=k;
	}
void movieObject::setChromaKeyColor(double r, double g, double b)
	{
	chromaKeyColor[0]=r;
	chromaKeyColor[1]=g;
	chromaKeyColor[2]=b;
	}
void movieObject::setChromaKeyTolerance(double t)
	{
	chromaKeyTolerance=t;
	}
void movieObject::setChromaKeyFuzziness(double f)
	{
	chromaKeyFuzziness=f;
	}
	
void movieObject::open(const ygString& file)
	{
	close();
	printf ("opening...\n");
	movie = oqt_open_file(file.c_str(),OQT_MODE_READ);
	
	if (movie)
		{
		if (oqt_read_headers(movie))
			printf ("no MOOV atom!\n");
		else
			printf ("read headers successful\n");
		width = oqt_get_video_width(movie,0);
		height = oqt_get_video_height(movie,0);
		rate = oqt_get_video_framerate(movie,0);
		length = oqt_get_video_length(movie,0);
		printf ("width:%d height:%d rate:%d length:%d\n",
			width,height,rate,length
		);
		yuv[0] = (unsigned char*)malloc(width*height*sizeof(unsigned char));
		yuv[1] = (unsigned char*)malloc((width/2)*(height/2)*sizeof(unsigned char));
		yuv[2] = (unsigned char*)malloc((width/2)*(height/2)*sizeof(unsigned char));
		}
	}

void movieObject::close(void)
	{
	if (movie)
		oqt_close(movie);
	movie = NULL;
	}
double movieObject::chromaKey(double r,double g, double b)
{
	double d,dr,dg,db,a,f;
	dr=r-chromaKeyColor[0];
	dg=g-chromaKeyColor[1];
	db=b-chromaKeyColor[2];
	d=sqrt(dr*dr+dg*dg+db*db);
	if (d<chromaKeyTolerance)
		a=0.0;
	else if (d<(chromaKeyTolerance+chromaKeyFuzziness))
	{
		f=d-chromaKeyTolerance;
		a=(f/chromaKeyFuzziness)*255.0;
	}	
	else
		a= 255.0;
	return a;
}
bool movieObject::getFrame(int frame,unsigned char* buffer)
	{
	
	if (movie)
	{
		if (loop)
			frame = frame % length;
		if (frame<length)
		{
		oqt_set_video_position(movie,0,frame);
		oqt_decode_video(movie,0,BC_YUV420P,yuv);
	
		double y,u,v;
		double r,g,b,a;
		for (int i=0;i<height;i++)
			{
			for (int j=0;j<width;j++)
				{
				int ir = height-1-i;
				int ir2 = ir/2;
				int j2 = j/2;
				y = (double)yuv[0][ir*width+j];
				u = (double)yuv[1][ir2*width/2+j2];
				v = (double)yuv[2][ir2*width/2+j2];
			
				// convert color space
				r = 1 * y -  0.0009267*(u-128) + 1.4016868*(v-128);
				g = 1 * y -  0.3436954*(u-128) - 0.7141690*(v-128);
				b = 1 * y +  1.7721604*(u-128) + 0.0009902*(v-128);
			
				//a=255;
				if (useChromaKey)
					a=chromaKey(r,g,b);
				else
					a=255;
				buffer[(i*width*4)+(j*4)] = a;
				buffer[(i*width*4)+(j*4)+1] = (unsigned char) (b>255)?255:((b<0)?0:b);
				buffer[(i*width*4)+(j*4)+2] = (unsigned char) (g>255)?255:((g<0)?0:g);
				buffer[(i*width*4)+(j*4)+3] = (unsigned char) (r>255)?255:((r<0)?0:r);
				}
			}
		return true;
		}
	}	
	return false;
	}

#endif

bool movieObject::isOpen(void)
	{
	if (movie)
		return 1;
	return 0;
	}

int movieObject::getWidth(void)
	{
	return width;
	}

int movieObject::getHeight(void)
	{
	return height;
	}

int movieObject::getLength(void)
	{
	return length;
	}

int movieObject::getRate(void)
	{
	return rate;
	}
	
void movieObject::setLoop(bool l)
	{
	loop = l;
	}