// Vertex Shader for procedural bump mapping

varying vec3 LightDir;
varying vec3 EyeDir;


uniform vec3 LightPosition;

attribute vec3 Tangent;

void main (void)
{
	//vec3 Tangent = vec3 (1,0,0);
	EyeDir = vec3 (gl_ModelViewMatrix * gl_Vertex);
	gl_Position = ftransform();
	gl_TexCoord[0] = gl_MultiTexCoord0;

	vec3 n = normalize(gl_NormalMatrix * gl_Normal);
	vec3 t = normalize(gl_NormalMatrix * Tangent);
	vec3 b = cross (n,t);
	vec3 v;
	v.x = dot(LightPosition,t);
	v.y = dot(LightPosition,b);
	v.z = dot(LightPosition,n);

	LightDir = normalize(v);

	v.x = dot(EyeDir,t);
	v.y = dot(EyeDir,b);
	v.z = dot(EyeDir,n);

	EyeDir = normalize(v);
	
}