// Fragment Shader for Bump Mapping

varying vec3 LightDir;
varying vec3 EyeDir;

uniform vec3 SurfaceColor;
uniform float BumpDensity;
uniform float BumpSize;
uniform float SpecularFactor;
uniform sampler2D TheTexture;
void main (void)
{
	vec3 litColor;
	vec3 normDelta;
	vec3 p;
	normDelta =  vec3 (texture2D(TheTexture, gl_TexCoord[0].st));

	normDelta *= 2.0;
	normDelta -= 1.0;

	//p = p + Normal;
	//float f=1.0;

	//vec3 normDelta = vec3 (p.x,p.y,p.z) * f;
	litColor = SurfaceColor * max(dot(normDelta, LightDir),0.0);
	vec3 reflectDir = reflect(LightDir,normDelta);
	
	float spec = max (dot(EyeDir,reflectDir),0.0);
	spec = pow(spec,6.0);
	spec *= SpecularFactor;
	litColor = min (litColor+spec,vec3(1.0));
	
	//litColor = p;
	gl_FragColor = vec4(litColor,1.0);

}