
uniform vec3 LightPosition;
uniform vec4 diffuse;
const float SpecularContribution = 0.3;
const float DiffuseContribution = 1.0 - SpecularContribution;

varying float LightIntensity;
varying vec2 MCposition;

void main (void)
{
	vec4 ecPosition;
	vec3 ecPosition3;

	// calculate eye position
	ecPosition= gl_ModelViewMatrix * gl_Vertex;
	ecPosition3 = (vec3 (ecPosition)) / ecPosition.w;
	
	// transform normal
	vec3 normal = gl_NormalMatrix * gl_Normal;
	normal = normalize(normal);
	normal = normal * gl_NormalScale;

	gl_TexCoord[0] = gl_TextureMatrix[0] * gl_MultiTexCoord0;

	vec3 lightVec = normalize (LightPosition - ecPosition);
	vec3 reflectVec = reflect (-lightVec,normal);
	vec3 viewVec = normalize (-ecPosition);
	float diffuse = max(dot(lightVec,normal),0.0);
	float spec = 0.0;

	if (diffuse > 0.0)
	{
		spec = max (dot(reflectVec,viewVec),0.0);
		spec = pow(spec,16.0);
	}

	LightIntensity = DiffuseContribution * diffuse + SpecularContribution * spec;

	MCposition = gl_Vertex.xy;	

	gl_Position = ftransform ();
	vec4 color = diffuse * LightIntensity;

	gl_FrontColor = color;
}