#ifndef _YGANIMATIONENGINE_H_
#define _YGANIMATIONENGINE_H_

#include <vector>
#include <ygNode.h>
#include <ygTransform.h>
#include <Performer/pf/pfDCS.h>
#include "mayaAnimEngine/animEngine.h"
//#include "animatedChannel.h"

typedef struct {
	pfMatrix Sp;
	pfMatrix SpI;
	pfMatrix S;
	pfMatrix St;
	pfMatrix Rp;
	pfMatrix RpI;
	pfMatrix Ro;
	pfMatrix R;
	pfMatrix Rt;
	pfMatrix T;
} matrixData;

void printOutMatrix (pfMatrix &mat,const char *matrixname);
void calculateTransformMatrix (pfMatrix *mat,matrixData *md);

class mayaAnimation : public ygNode
{
public:
	mayaAnimation(const char* name,bool master=true);
	~mayaAnimation(void);
	void reset(void);
	void message(const ygMessage&);
	void loadPath(const ygString& file);
	void app (void);
	void acceptNetKey (const ygString &key);
	int loadFile(const ygString& file,float offset);
	void startClip(int);
	void stopClip();
	void clearClips ();
	void setTimeScale(float s);
	void setPreInfinity(int c,const ygString& s);
	void setPostInfinity(int c,const ygString& s);
	
private:
	
	
	
	
/***** Internal Classes **********/
	class animatedChannel {
		public: 
			animatedChannel();
			animatedChannel(bool dbg);
			void start(float time);
			void stop();
			float evaluate(float currentTime);
			bool isActive();
			bool hasCurve();
			void setName (const char *n);
			void setName (ygString n);
			inline void setTimeScale (float s) { timeScale = s;}
			float getTimeScale () { return timeScale;}
			void setPreInfinity (EtInfinityType inf);
			void setPostInfinity (EtInfinityType inf);
			EtInfinityType getPreInfinity();
			EtInfinityType getPostInfinity();
			bool beyondEnd();
			bool beyondBeginning();
			int numLoops();
			bool loopOccurred();

			ygString name;
			EtChannel *etchannel;
			float startTime;
			float currentTime;
			float timeScale;
			float currentRealTime;
			bool active;	
			int loopCount;
		private:
			
			bool debug;		 
	};
	

	class animatedNode {	
		public: 
			animatedNode ();
			animatedNode(ygString name,pfGroup *pfg);
			animatedNode(ygString name,pfGroup *pfg, bool dbg);
			void start(float time);
			void start(ygString channel);
			void stop();
			int evaluate(float currentTime);
			int attach (pfGroup *);
			int linkChannel (EtChannel *etchannel,ygString channelName);
			void setTimeScale (float s);
			bool beyondEnd();
			bool beyondBeginning();
			void setPreInfinity (EtInfinityType inf);
			void setPostInfinity (EtInfinityType inf);
			bool preInfinityIsConstant ();
			bool postInfinityIsConstant ();
			pfDCS* getDCS ();
			bool loopOccurred();
			void setInitialValues();
			ygString nodeName;
			animatedChannel channels[10];
			int channelCount;
		private:
			EtChannel* findChannel (EtChannel * channelList, ygString objectName, char *channelName);
			pfDCS *dcs; 
			matrixData* matrixdata;
			float timeScale;
			int findDCS(pfGroup *findFrom);   // finds the DCS
			matrixData * findMatrixData (pfDCS* d);	
			bool debug;
			EtValue translate[3], rotate[3], scale[3], visibility;		
	};

	class animatedClip {
		public:
			animatedClip ();
			animatedClip (bool dbg);
			animatedClip(ygString fileName);
			animatedClip(ygString fileName,bool dbg);
			animatedClip(ygString fileName,float timeoffset, bool dbg);
			~animatedClip ();
			int loadFile(ygString fileName);
			void start();
			void start(ygString node);
			void start(ygString node,ygString channel,float time); 
			void stop();
			void stop(ygString node);
			void stop(ygString node,ygString channel);
			void setTimeScale(float s);
			bool beyondEnd();
			bool beyondBeginning();	
			void setPreInfinity (EtInfinityType inf);
			void setPostInfinity (EtInfinityType inf);
			bool preInfinityIsConstant ();
			bool postInfinityIsConstant ();		
			int evaluate (float currentTime);
			int initialize (pfGroup *pfg);
			int attachNodes (pfGroup *pfg);
			bool loopOccurred();
			void setOffset(float offset);
			bool initializationComplete;
		private:
			EtChannel *channelList;
			EtInt numCurves;
			pfGroup * pfnode;
			std::vector<animatedNode *> nodes;
			int findAnimatedNode (ygString name);
			bool debug;
			float timeScale;
			float timeOffset;
			
			
	};

struct _mayaAnimationPrivateData
{
	pfGroup * pfgroup;
	pfMatrix netMatrix;
	bool active;
	bool loop;	
	std::vector<animatedClip *> clips;
	int currentClip;
	bool firstFrame;
	bool debugVerbose;
	float timeScale;
	int netStartClip;
	ygString netClipFileName;
	bool netActive;
	int netClearClips;
	bool autoStop;
	
};
struct _mayaAnimationPrivateData *p_;
	
	
};


#endif
