/* animatedNode, animatedChannel, animatedClip */

#include "mayaAnimation.h"
#include "myStringUtil.h"

#include <ygUtil.h>
#include <ygWorld.h>

/***************************************************

	animatedNode
	
***************************************************/



mayaAnimation::animatedNode::animatedNode (ygString name, pfGroup * pfgroup)
{
	int err;
	
	nodeName = name;
	dcs = NULL;
	channels[0].setName("translateX");
	channels[1].setName("translateY");
	channels[2].setName("translateZ");
	channels[3].setName("rotateX");
	channels[4].setName("rotateY");
	channels[5].setName("rotateZ");
	channels[6].setName("scaleX");
	channels[7].setName("scaleY");
	channels[8].setName("scaleZ");
	channels[9].setName("visibility");
	channelCount=10;
	timeScale=1.0;
	err = findDCS (pfgroup);
	if (dcs) {
		matrixdata = findMatrixData (dcs);
	}
	debug=0;
	setInitialValues ();
}
mayaAnimation::animatedNode::animatedNode (ygString name,pfGroup *pfgroup, bool dbg)
{
	debug=dbg;
	int err;
	bool found;
	
	nodeName = name;
	dcs = NULL;
	channels[0].setName("translateX");
	channels[1].setName("translateY");
	channels[2].setName("translateZ");
	channels[3].setName("rotateX");
	channels[4].setName("rotateY");
	channels[5].setName("rotateZ");
	channels[6].setName("scaleX");
	channels[7].setName("scaleY");
	channels[8].setName("scaleZ");
	channels[9].setName("visibility");
	channelCount=10;
	timeScale=1.0;
	if (debug) 
		fprintf (stderr,"  animatedNode(): %s\n",name.c_str());
	/* ???? */
	attach (pfgroup);
	setInitialValues ();
}
void mayaAnimation::animatedNode::setInitialValues ()
{
	if (dcs)
	{
		pfMatrix mat;
		pfCoord coord;
		dcs->getMat(mat);
		mat.getOrthoCoord(&coord);
		translate[0]=coord.xyz[0];
		translate[1]=coord.xyz[1];
		translate[2]=coord.xyz[2];
		rotate[0]=coord.hpr[1];
		rotate[1]=coord.hpr[2];
		rotate[2]=coord.hpr[0];
		printf ("Setting initial values: %f %f %f\n",translate[0],translate[1],translate[2]);
	}
	else
	{
		printf ("I guess I don't have a dcs yet\n");
		translate[0]=translate[1]=translate[2]=0;
		rotate[0]=rotate[1]=rotate[2]=0;
		scale[0]=scale[1]=scale[2]=1;
		visibility=1;
	}
}
int mayaAnimation::animatedNode::attach (pfGroup * pfgroup)
{
	bool found;
	found = findDCS (pfgroup);
	if (debug) {
		if (!found) fprintf (stderr,"    (NOT FOUND)\n");	
		else fprintf (stderr,"    (found)\n");
	}
	
	if (dcs) {
		matrixdata = findMatrixData (dcs);
	}	
}

void mayaAnimation::animatedNode::setTimeScale (float s)
{
	for (int i=0;i<channelCount;i++) 
		channels[i].setTimeScale(s);
}

int mayaAnimation::animatedNode::linkChannel (EtChannel *etchannel, ygString channelName)
{
	int success=0;
	int i;
	for (i=0;i<channelCount;i++) 
		if (channelName==channels[i].name) {
			channels[i].etchannel=etchannel;
			success=true;
			break;
		}
	return success;
}

void mayaAnimation::animatedNode::start(float time)
{
	// start all channels
	if (debug)
		fprintf (stderr,"    animatedNode::start()\n");
	for (int i=0;i<channelCount;i++) {
		channels[i].start(time);
	}
}

void mayaAnimation::animatedNode::stop()
{
	// stop all channels
	for (int i=0;i<channelCount;i++) {
		channels[i].stop();
	}	
}

bool mayaAnimation::animatedNode::beyondEnd()
{
	for (int i=0;i<channelCount;i++)
		if (!channels[i].beyondEnd())
			return false;

	return true;
}
bool mayaAnimation::animatedNode::beyondBeginning()
{
	for (int i=0;i<channelCount;i++)
		if (!channels[i].beyondBeginning())
			return false;

	return true;
}

bool mayaAnimation::animatedNode::loopOccurred()
{
	for (int i=0;i<channelCount;i++)
		if (channels[i].loopOccurred())
			return true;

	return false;	
}

void mayaAnimation::animatedNode::setPreInfinity (EtInfinityType inf)
{
	printf ("node: setting postinfinity\n");
	for (int i=0;i<channelCount;i++)
		channels[i].setPreInfinity(inf);
}
void mayaAnimation::animatedNode::setPostInfinity (EtInfinityType inf)
{
	printf ("node: setting postinfinity\n");
	for (int i=0;i<channelCount;i++)
		channels[i].setPostInfinity(inf);
}

bool mayaAnimation::animatedNode::preInfinityIsConstant ()
{
	for (int i=0;i<channelCount;i++)
		if (channels[i].getPreInfinity() != kInfinityConstant)
			return false;
	return true;
}
bool mayaAnimation::animatedNode::postInfinityIsConstant ()
{
	for (int i=0;i<channelCount;i++)
		if (channels[i].getPostInfinity() != kInfinityConstant)
			return false;
	return true;
}
int mayaAnimation::animatedNode::evaluate(float time)
{
	// get the values for all curves, update the DCS
	

	

	
	if (channels[0].hasCurve() && channels[0].isActive())
		translate[0] = channels[0].evaluate(time);	
	
	if (channels[1].hasCurve() && channels[1].isActive())
		translate[1] = channels[1].evaluate(time);
		
	if (channels[2].hasCurve() && channels[2].isActive())
		translate[2] = channels[2].evaluate(time);
	

	if (channels[3].hasCurve() && channels[3].isActive())		
		rotate[0] = channels[3].evaluate(time) * 360.0 / 6.28318;
	

	if (channels[4].hasCurve() && channels[4].isActive())		
		rotate[1] = channels[4].evaluate(time) * 360.0 / 6.28318;
	

	if (channels[5].hasCurve() && channels[5].isActive())	
		
		rotate[2] = channels[5].evaluate(time) * 360.0 / 6.28318;
		
	
	if (channels[6].hasCurve() && channels[6].isActive())	
		scale[0] = channels[6].evaluate(time);
		
	if (channels[7].hasCurve() && channels[7].isActive())	
		scale[1] = channels[7].evaluate(time);
		
	if (channels[8].hasCurve() && channels[8].isActive())	
		scale[2] = channels[8].evaluate(time);
	
	if (channels[9].hasCurve() && channels[9].isActive())
		visibility = channels[9].evaluate(time);

		
	if (dcs) {
		pfMatrix newmatrix;
		newmatrix.makeIdent();
		if (matrixdata)
		{
			matrixdata->T.makeTrans(translate[0],translate[1],translate[2]);
			matrixdata->S.makeScale(scale[0],scale[1],scale[2]);
			matrixdata->R.makeEuler(rotate[2],rotate[0],rotate[1]);
			calculateTransformMatrix (&newmatrix,matrixdata);

			//std::cerr << newmatrix;
			dcs->setMat(newmatrix);

		}
		else {
			dcs->setTrans(translate[0],translate[1],translate[2]);
			dcs->setRot(rotate[2],rotate[0],rotate[1]);
			dcs->setScale(scale[0],scale[1],scale[2]);
		}
		if (visibility)
			dcs->setTravMask(PFTRAV_DRAW, 0xffffffff,
				PFTRAV_SELF|PFTRAV_DESCEND, PF_SET);
		else
			dcs->setTravMask(PFTRAV_DRAW, 0,
					PFTRAV_SELF|PFTRAV_DESCEND, PF_SET);	
	}
	//printf ("finished animatedNode::evaluate()\n");
}

int mayaAnimation::animatedNode::findDCS (pfGroup *searchFrom)
{
	
	dcs = (pfDCS*) searchFrom->find (nodeName.c_str(),pfDCS::getClassType());
	if (dcs) return true;
	else return false;

}

// return the DCS that this node attaches to
pfDCS * mayaAnimation::animatedNode::getDCS ()
{
	return dcs;
}

matrixData* mayaAnimation::animatedNode::findMatrixData (pfDCS *d)
{
	/* 
		look for user data slot that holds matrices.  if it's there, update those and use that info.
		otherwise, just do it the simple way.
	*/
	
	matrixData * matrixdata=NULL;
	const char *slotname;
	if (d) {
		int numslots = d->getNumNamedUserDataSlots ();
		for (int i=0;i<numslots;i++) {
			slotname=d->getUserDataSlotName(i);
			if (!strcmp(slotname,"matrices"))
			{	
				matrixdata=(matrixData*) d->getUserData(i);
				//std::cerr<< "    Found Matrix Data at Slot " << i << "\n";
			}
		}
	}
	return matrixdata;
	
}

void printOutMatrix (pfMatrix &mat,const char *matrixname)
{
	int r,c;
	fprintf (stderr,"%s\n",matrixname);
	for (r=0;r<4;r++)
	{
		fprintf (stderr,"%f %f %f %f\n",mat[r][0],mat[r][1],mat[r][2],mat[r][3]);
	}
	fprintf (stderr,"\n");
}

void calculateTransformMatrix (pfMatrix *mat,matrixData *md)
{
	mat->postMult(md->SpI);
	mat->postMult(md->S);
	mat->postMult(md->Sp);
	mat->postMult(md->St);
	mat->postMult(md->RpI);
	mat->postMult(md->R);
	mat->postMult(md->Rp);
	mat->postMult(md->Rt);
	mat->postMult(md->T);
}
