/* animatedNode, animatedChannel, animatedClip */

#include "mayaAnimation.h"

#include "myStringUtil.h"

#include "mayaAnimEngine/animEngine.h"

#include <ygUtil.h>
#include <ygWorld.h>
/****************************************


		animatedClip 
	
			
***************************************/

mayaAnimation::animatedClip::animatedClip ()
{
	this->timeOffset = 0;
	debug = false;
	pfnode = NULL;
	channelList=NULL;
	numCurves=0;
	timeScale = 1.0;
	initializationComplete = false;	
}

mayaAnimation::animatedClip::animatedClip (bool dbg)
{
	this->timeOffset = 0;
	debug = dbg;
	pfnode = NULL;
	channelList=NULL;
	numCurves=0;
	timeScale = 1.0;
	initializationComplete = false;	
}

mayaAnimation::animatedClip::animatedClip (ygString fileName)
{
	this->timeOffset = 0;
	debug = false;
	pfnode = NULL;
	channelList=NULL;
	numCurves=0;
	timeScale = 1.0;
	initializationComplete = false;	
	loadFile (fileName);
	
}
mayaAnimation::animatedClip::animatedClip (ygString fileName,float timeOffset,bool dbg)
{
	this->timeOffset = timeOffset;
	debug = dbg;
	pfnode = NULL;
	channelList=NULL;
	numCurves=0;
	timeScale = 1.0;
	initializationComplete = false;	
	loadFile (fileName);
	
}
mayaAnimation::animatedClip::~animatedClip ()
{
	if (channelList)
		delete channelList;
	for (int i=0;i<nodes.size();i++)
		delete nodes[i];
	
}

void mayaAnimation::animatedClip::setOffset (float offset)
{
	this->timeOffset = offset;
}
int mayaAnimation::animatedClip::loadFile(ygString fileName)
{
	char *searchPath = ".", line[512];
	ygString fullPath;
	FILE *fp=NULL;
	int err;
	
	if (debug)
		fprintf (stderr,"animatedClip::loadFile\n");
	
	if (getenv("YG_PATH"))
		searchPath = getenv("YG_PATH");
	if (!ygFindFile(fileName,searchPath,fullPath))
		{
		fprintf(stderr,"ERROR: mayaAnimation::loadPath: could not find file '%s'\n",
			fileName.c_str());
		return (-1);
		}
	else 
		fprintf (stderr,"loading %s\n",fullPath.c_str());
	channelList = engineAnimReadCurves (fullPath.c_str(), &numCurves);
	
	if (channelList == kEngineNULL) {
		fprintf (stderr, "##### Unable to parse %s\n", fullPath.c_str());
		return (-1);
	}
	else if (debug)
		fprintf (stderr,"finished reading function; numCurves=%d\n",numCurves);
	return (0);
	
}

int mayaAnimation::animatedClip::initialize (pfGroup *pfg)
{
	char nodename_c[256],channelname_c[256];
	ygString nodename;
	ygString channelname;
	pfnode = pfg;
	int success=1;
	
	/* now go through and match up channels into animatedNodes */
	
	if (channelList) 
	{
	EtChannel *channel = channelList;
	
	if (debug)
		fprintf (stderr,"AnimatedClip:analyzing channels\n");
	
	while(channel != kEngineNULL) {
		if (debug)
			fprintf (stderr,"  EtChannel=%s\n",channel->channel);
		
		split((char *) channel->channel,'.',nodename_c,channelname_c);
		
		if (debug)
			fprintf (stderr,"  node:%s channel:%s\n",nodename_c,channelname_c);
		
		nodename = nodename_c;
		channelname = channelname_c;
		int nodeindex = findAnimatedNode (nodename);
		
		// this is a DCS we've already located and attached to 
		if (debug && nodeindex>=0)
			fprintf (stderr,"  (ok)\n",nodeindex);
		
		// haven't attached to this one yet, so try to attach it
		if (nodeindex<0) {
			animatedNode * n = new animatedNode (nodename,pfnode,debug);
			if (! n->getDCS())
				success=0;
				
			if (debug)
				fprintf (stderr,"  made new animatedNode\n");
			
			nodes.push_back(n);
			nodeindex = nodes.size() - 1;
		}	
		nodes[nodeindex]->linkChannel (channel,channelname);
		channel = channel->next;
	}
	
	initializationComplete = success;	
	}
	else {
		success = 0;
	}
	return success;
}

int mayaAnimation::animatedClip::attachNodes (pfGroup *pfgroup)
{
	
	int i;
	int success=1;
	int onesuccess;
	if (!initializationComplete)
	{
		for (i=0;i<nodes.size();i++)
		{
			onesuccess = nodes[i]->attach (pfgroup);
			if (!onesuccess)
				success=0;
			else
				nodes[i]->setInitialValues();
		}
	
	}
	initializationComplete=success;
	return success;
}

int mayaAnimation::animatedClip::findAnimatedNode (ygString name)
{
	int i;
	int thenode = -1;

	for (i=0;i<nodes.size();i++) {
		if (name==nodes[i]->nodeName) {
			thenode=i;
			break;
		}
	}
	return thenode;
}

void mayaAnimation::animatedClip::start (ygString nodename, ygString channelname, float time)
{
	// for right now, we'll ignore the nodename and channelname options
	// and just start everything.
	
	if (debug)
		fprintf (stderr,"animatedClip::start()\n");
	
	for (int i=0;i<nodes.size();i++) {
		nodes[i]->start (time);
	}

}
void mayaAnimation::animatedClip::stop ()
{
	// for right now, we'll ignore the nodename and channelname options
	// and just stop everything.
	
	for (int i=0;i<nodes.size();i++) {
		nodes[i]->stop ();
	}
}

int mayaAnimation::animatedClip::evaluate (float t)
{

	for (int i=0;i<nodes.size();i++) {
		nodes[i]->evaluate (t);
	}

}

void mayaAnimation::animatedClip::setTimeScale(float s)
{
	for (int i=0;i<nodes.size();i++) {
		nodes[i]->setTimeScale(s);
	}	
}

bool mayaAnimation::animatedClip::beyondEnd()
{
	for (int i=0;i<nodes.size();i++) {
		if (!nodes[i]->beyondEnd())
			return false;
	}	
	return true;
}	

bool mayaAnimation::animatedClip::beyondBeginning()
{
	for (int i=0;i<nodes.size();i++) {
		if (!nodes[i]->beyondBeginning())
			return false;
	}	
	return true;
}	

bool mayaAnimation::animatedClip::loopOccurred()
{
	for (int i=0;i<nodes.size();i++) {
		if (nodes[i]->loopOccurred())
			return true;
	}	
	return false;
}	


void mayaAnimation::animatedClip::setPreInfinity (EtInfinityType inf)
{
	for (int i=0;i<nodes.size();i++) {
		nodes[i]->setPreInfinity(inf);
	}
}
void mayaAnimation::animatedClip::setPostInfinity (EtInfinityType inf)
{
	printf ("animatedClip: setPostInfinity time\n");
	printf ("number of nodes:%d\n",nodes.size());
	for (int i=0;i<nodes.size();i++) {
		nodes[i]->setPostInfinity(inf);
	}
}
bool mayaAnimation::animatedClip::preInfinityIsConstant ()
{
	for (int i=0;i<nodes.size();i++) {
		if (!nodes[i]->preInfinityIsConstant())
			return false;
	}	
	return true;
}
bool mayaAnimation::animatedClip::postInfinityIsConstant ()
{
	for (int i=0;i<nodes.size();i++) {
		if (!nodes[i]->postInfinityIsConstant())
			return false;
	}	
	return true;
}




