#include "mayaAnimation.h"

#include "myStringUtil.h"


#include <ygUtil.h>
#include <ygWorld.h>
/*******************************************************
	
	animatedChannel 
	
******************************************************/

mayaAnimation::animatedChannel::animatedChannel ()
{
	etchannel=kEngineNULL;
	startTime=0;
	currentTime=0;
	currentRealTime=0;
	timeScale=1.0;
	active=false;
	loopCount=0;
}
mayaAnimation::animatedChannel::animatedChannel (bool dbg)
{
	debug = dbg;
	etchannel=kEngineNULL;
	startTime=0;
	active=false;
}
void mayaAnimation::animatedChannel::start (float time)
{
	currentRealTime=time;
	currentTime=0;
	startTime = time;
	active=true;
}

void mayaAnimation::animatedChannel::stop ()
{
	active=false;
}
float mayaAnimation::animatedChannel::evaluate (float newRealTime)
{
	float result=0;
	float dRT = newRealTime-currentRealTime;
	float dT = dRT * timeScale;
	currentTime +=dT;

	if (etchannel != kEngineNULL)
		result = engineAnimEvaluate (etchannel->curve,(EtTime) currentTime);

	currentRealTime=newRealTime;
	return result;
}

void mayaAnimation::animatedChannel::setName (const char *n)
{
	name=n;
}

void mayaAnimation::animatedChannel::setName (ygString n)
{
	name=n;
}

bool mayaAnimation::animatedChannel::isActive ()
{
	return active;
}

bool mayaAnimation::animatedChannel::hasCurve ()
{
	if (etchannel == kEngineNULL)
		return false;
	else
		return true;
}

bool mayaAnimation::animatedChannel::beyondEnd ()
{
	EtCurve *curve;
	if (hasCurve())
	{
		curve = etchannel->curve;
		
		if (currentTime >= curve->keyList[curve->numKeys - 1].time)
		{
			return true;
		}
	}
	else
		return false;	
}

// divide current time by length of curve to find out how many loops we've done
int mayaAnimation::animatedChannel::numLoops()
{
	int loops=0;
	EtCurve *curve;
	if (hasCurve())
	{
		curve = etchannel->curve;

		if (curve->numKeys>1)
			loops = currentTime / curve->keyList[curve->numKeys-1].time;
	}
	return loops;
}

bool mayaAnimation::animatedChannel::loopOccurred()
{
	int newLoopCount = numLoops();
	if (newLoopCount != loopCount)
	{
		
		//printf ("%d %d %f %f %d\n",loopCount,newLoopCount,currentTime,etchannel->curve->keyList[etchannel->curve->numKeys].time,etchannel->curve->numKeys);
		loopCount = newLoopCount;
		
		return true;
	}	
	else
	{
		return false;
	}
}


bool mayaAnimation::animatedChannel::beyondBeginning ()
{
	if (currentTime < 0)
		return true;
	else
		return false;
}
void mayaAnimation::animatedChannel::setPreInfinity(EtInfinityType inf)
{
	if (hasCurve())
		etchannel->curve->preInfinity = inf;
}

void mayaAnimation::animatedChannel::setPostInfinity(EtInfinityType inf)
{
	if (hasCurve())
		etchannel->curve->postInfinity = inf;
}
EtInfinityType mayaAnimation::animatedChannel::getPreInfinity()
{
	if (hasCurve())
		return etchannel->curve->preInfinity;
	else
		return kInfinityConstant;
}
EtInfinityType mayaAnimation::animatedChannel::getPostInfinity()
{
	if (hasCurve ())
		return etchannel->curve->postInfinity;
	else
		return kInfinityConstant;
}

