/******************************************************************
 * CAVERNsoft
 * Copyright (C) 1994-2002 Electronic Visualization Laboratory,
 * all rights reserved
 * By Jason Leigh, Yong-joo Cho, Naveen Krishnaprasad, Chris Scharver,
 * Stuart Bailey, Atul Nayak, Shalini Venkataraman, Joshua Eliason,
 * Javid Alimohideen 
 * University of Illinois at Chicago
 * 
 * This publication and its text and code may not be copied for commercial 
 * use without the express written permission of the University of Illinois
 * at Chicago.
 * The contributors disclaim any representation of warranty: use this
 * code at your own risk.
 * Direct questions, comments etc to cavern@evl.uic.edu
 ******************************************************************/

#if defined(WIN32) && defined(CAVERN_USE_WINDOWSTHREADS)

#ifndef __PTHREAD_WIN_H_
#define __PTHREAD_WIN_H_

/* This program is largely based on "Strategies for Implementing POSIX Condition
   Variables on Win32" written by Douglas C. Schmidt and Irfan Pyarali and published
   in C++ Report, Vol. 10, No. 5, June, 1998 issue. You can get the full article from
   "http://www.cs.wustl.edu/~schmidt/win32-cv-1.html". I fixed a few things from the
   code and added pthread_win_cond_destroy function. 
*/

#include <windows.h>
#include "CAVERNts_mutex_c.hxx"

struct pthread_win_cond_t
{
    int waiters_count_;
    // Count of the number of waiters.

    CRITICAL_SECTION waiters_count_lock_;
    // Serialize access to <waiters_count_>.

    int release_count_;
    // Number of threads to release via a <pthread_cond_broadcast> or a
    // <pthread_cond_signal>. 
  
    int wait_generation_count_;
    // Keeps track of the current "generation" so that we don't allow
    // one thread to steal all the "releases" from the broadcast.

    HANDLE event_;
    // A manual-reset event that's used to block and release waiting
    // threads. 
};

int pthread_win_cond_init(struct pthread_win_cond_t *cv);
int pthread_win_cond_wait(struct pthread_win_cond_t *cv,
                          CAVERNts_mutex_c *external_mutex);
int pthread_win_cond_signal(struct pthread_win_cond_t *cv);
int pthread_win_cond_broadcast(struct pthread_win_cond_t *cv);
int pthread_win_cond_destroy(struct pthread_win_cond_t *cv);

#endif

#endif
