/******************************************************************
 * CAVERNsoft
 * Copyright (C) 1994-2002 Electronic Visualization Laboratory,
 * all rights reserved
 * By Jason Leigh, Yong-joo Cho, Naveen Krishnaprasad, Chris Scharver,
 * Stuart Bailey, Atul Nayak, Shalini Venkataraman, Joshua Eliason,
 * Javid Alimohideen 
 * University of Illinois at Chicago
 * 
 * This publication and its text and code may not be copied for commercial 
 * use without the express written permission of the University of Illinois
 * at Chicago.
 * The contributors disclaim any representation of warranty: use this
 * code at your own risk.
 * Direct questions, comments etc to cavern@evl.uic.edu
 ******************************************************************/

/*This file has functions that are used for performance monitoring while using udp connections with the CAVERNnet_udp_c class 
A header containing the timestamp is prepended while a message is sent and the header is unprepended when the message is read.

Note:
Instrumentation should be enabled on both the server and the client sides to turn on the performance monitoring
*/
 
#ifndef _CAVERN_PERFMON
#define _CAVERN_PERFMON

///return the size of the performance_monitoring header
int _cavern_getSizeOfPerformanceMonitoringHeader();

///Prepend the message with the performance_monitoring header
void _cavern_prependPerformanceMonitoringHeader(char* newmsg, char* message, int length);

///Allocate memory for the new message - to include the performance_monitoring header
char* _cavern_allocMemForPerformanceMonitoredMesg(int length, int * newlength);

///Unprepend the performance_monitoring header
void _cavern_unprependPerformanceMonitoringHeader(double *remoteTimeStamp, double *inlatency, char* newmsg, int newlen,  char* message, int *ulen);


#endif

