/******************************************************************
 * CAVERNsoft
 * Copyright (C) 1994-2002 Electronic Visualization Laboratory,
 * all rights reserved
 * By Jason Leigh, Yong-joo Cho, Naveen Krishnaprasad, Chris Scharver,
 * Stuart Bailey, Atul Nayak, Shalini Venkataraman, Joshua Eliason,
 * Javid Alimohideen 
 * University of Illinois at Chicago
 * 
 * This publication and its text and code may not be copied for commercial 
 * use without the express written permission of the University of Illinois
 * at Chicago.
 * The contributors disclaim any representation of warranty: use this
 * code at your own risk.
 * Direct questions, comments etc to cavern@evl.uic.edu
 ******************************************************************/
#ifndef _MD5KEY_C
#define _MD5KEY_C

#include <stdio.h>
#if (defined(WIN32) || defined(linux))
#include <string.h>
#else
#include <strings.h>
#endif
#include "md5.hxx"

#define MD5KEY_SIZE 		16
#define MD5KEY_SIZE_2		33

/** MD5 encryption key. Give it a string and it will encrypt it into a 16 byte key.
  * Note: this class requires md5.h and md5.c which does the actual encryption work.
  */
class md5Key_c {
public:

//	static const int MD5KEY_SIZE/* = 16*/;
//	static const int MD5KEY_SIZE_2/* = 33*/; // 16 * 2 + 1 (extra byte for null character in string) [see getKeyAsStr()]

	md5Key_c() {memset(key, 0, MD5KEY_SIZE);}
        int operator=(md5Key_c& copy) {
            memcpy(keystr, copy.keystr, MD5KEY_SIZE_2);
            memcpy(key, copy.key, MD5KEY_SIZE);
	    return *this;
        }

	/// Hash a string of len with md5 encryption.
	int hash(char *str, int len) {
		if (len < 1) return 1;

		//		unsigned char *buf = (unsigned char*) str;

		unsigned char *buf = new unsigned char[len];

		if (!buf) return 0;

		MD5_CTX ctx;
		
		memcpy(buf,str,len);

		MD5Init(&ctx);
		MD5Update(&ctx, buf, len);
		MD5Final(key, &ctx);

		delete buf;

		return 1;
	}

	/// Conversion to integer (for use with hash tables)
	operator int() {

		// Basically it extracts the first 4 bytes and makes it an int.
		int *front = (int *) key;
		int copy;
		memcpy((char*) &copy, front, sizeof(int));
		if (copy < 0) copy = -copy;
		return copy;
	}

	/// Determine if 2 md5 keys are the same.
	int operator==(md5Key_c &nkey) {
		if (memcmp(nkey.key,key,MD5KEY_SIZE) ==0) return 1; else return 0;
	}

	int operator=(unsigned char* copy) {
		for (int i =0; i < MD5KEY_SIZE; i++)
			key[i] = copy[i];

		return *this;
	}

	/// Print the md5 key.
	void display() {
		printf(getKeyAsStr());
		printf("\n");
	}

	/// Retrieve MD5 key as a string that is printable.
	char *getKeyAsStr() {
		
		int i;
		char twoByte[3];

		memset(keystr, 0, 33);

		unsigned char* p = key;
		for (i = 0; i < MD5KEY_SIZE; ++i) {
			sprintf(twoByte,"%02x", *p++);
			strcat(keystr,twoByte);
		}

		return keystr;

	}


	/// MD5KEY_SIZE byte md5 encrypted key.
	unsigned char key[MD5KEY_SIZE];
	char keystr[MD5KEY_SIZE_2];


};

#endif
