/******************************************************************
 * CAVERNsoft
 * Copyright (C) 1994-2002 Electronic Visualization Laboratory,
 * all rights reserved
 * By Jason Leigh, Yong-joo Cho, Naveen Krishnaprasad, Chris Scharver,
 * Stuart Bailey, Atul Nayak, Shalini Venkataraman, Joshua Eliason,
 * Javid Alimohideen 
 * University of Illinois at Chicago
 * 
 * This publication and its text and code may not be copied for commercial 
 * use without the express written permission of the University of Illinois
 * at Chicago.
 * The contributors disclaim any representation of warranty: use this
 * code at your own risk.
 * Direct questions, comments etc to cavern@evl.uic.edu
 ******************************************************************/

#ifdef WIN32
#ifndef __GETTIMEOFDAY_H_
#define __GETTIMEOFDAY_H_

#include <winsock.h>

#ifdef __cplusplus
extern "C"
{
#endif

/** This function is provided only for Windows version of CAVERN library
    to be used in performance monitoring routines. It is not a perfect 
    solution to this problem but is working for CAVERN library.
    Note that CAVERNinit function must be called before using this function.
    If this function is used in 486 or older machines that do not provide
    the high performance counter, time will be measured in milliseconds level
    only. Thus, Pentium or higher machines must be used to measure the time 
    in microsecond level accuracy.

    There is a known bug in high performance counter that only happens on
    NEC PC9800 machine running Japanese Windows 95. This is excerpt from
    Microsoft's knowledgebase #Q152145:

    "QueryPerformanceFrequency called from an application running on an 
     NEC PC9800 Series computer with Japanese Win95 (PC9800 version), returns
     a static value (1193180 Ticks/sec) regardless of the actual frequency of 
     the actual frequency of the high-resolution performance counter. On NEC
     PC 9800 Series compuers, the static value can be 2457600 ticks/sec."

    @param struct timeval* tp Returns local time through this variable
       tp->tv_sec: Time in seconds since midnight (00:00:00), January 1, 1970, 
                   coordinated universal time (UTC).
       tp->tv_usec: Fraction of a second in microseconds.
    @param tzp Not supported time zone information. Must be NULL
    @return returns always 0.
 */
int gettimeofday(struct timeval *tp, void *tzp = NULL);

#ifdef __cplusplus
}
#endif

#endif
#endif
