/******************************************************************
 * CAVERNsoft
 * Copyright (C) 1994-2002 Electronic Visualization Laboratory,
 * all rights reserved
 * By Jason Leigh, Yong-joo Cho, Naveen Krishnaprasad, Chris Scharver,
 * Stuart Bailey, Atul Nayak, Shalini Venkataraman, Joshua Eliason,
 * Javid Alimohideen 
 * University of Illinois at Chicago
 * 
 * This publication and its text and code may not be copied for commercial 
 * use without the express written permission of the University of Illinois
 * at Chicago.
 * The contributors disclaim any representation of warranty: use this
 * code at your own risk.
 * Direct questions, comments etc to cavern@evl.uic.edu
 ******************************************************************/

#ifndef _CAVERNPLUS_THREAD_C
#define _CAVERNPLUS_THREAD_C

#include "CAVERN.hxx"

typedef void* (*CAVERN_THREADED_FUNC)(void*);

#ifdef CAVERN_USE_GLOBUS_THREADS
    typedef globus_thread_t CAVERN_THREAD_T;
#elif defined(CAVERN_USE_PTHREADS)
	typedef pthread_t CAVERN_THREAD_T;
#elif defined(WIN32) && defined(CAVERN_USE_WINDOWSTHREADS)
    typedef unsigned CAVERN_THREAD_T;
//    typedef unsigned (__stdcall *CAVERN_THREADED_FUNC)(void *);
//	typedef unsigned (__stdcall *THREAD_START) (void *);
#else
	#error One of CAVERN_USE_GLOBUS_THREADS, CAVERN_USE_PTHREADS, or CAVERN_USE_WINDOWSTHREADS must be defined.
#endif

/**
Thread class. Note: the CAVERNts_thread-related classes are intended to be
simplified versions of the globus/pthread interfaces so that beginners
can quickly create threaded programs. For greater control over threads
use the globus thread API which is very similar to the pthreads API.
*/
class CAVERNts_thread_c {
public:

	/** Create a thread.
	    @param threaded_func is your function that will be called in
	    a separate thread. The function needs to be of the form:

	    void * threaded_func(void *arg);

	    @param arg is the argument to pass to the threaded function.
	    @return 0 if thread successful, else non-zero.
	    */
	int create(void * (*threaded_func)(void *), void *arg);

	/// Return thread handle.
	CAVERN_THREAD_T *getThread();
    
    //Pthread exit function - works only for Unix based systems with pthread support

private:
	CAVERN_THREAD_T itsThread;
	
};
#endif
