/******************************************************************
 * CAVERNsoft
 * Copyright (C) 1994-2002 Electronic Visualization Laboratory,
 * all rights reserved
 * By Jason Leigh, Yong-joo Cho, Naveen Krishnaprasad, Chris Scharver,
 * Stuart Bailey, Atul Nayak, Shalini Venkataraman, Joshua Eliason,
 * Javid Alimohideen 
 * University of Illinois at Chicago
 * 
 * This publication and its text and code may not be copied for commercial 
 * use without the express written permission of the University of Illinois
 * at Chicago.
 * The contributors disclaim any representation of warranty: use this
 * code at your own risk.
 * Direct questions, comments etc to cavern@evl.uic.edu
 ******************************************************************/

#ifndef _CAVERNPLUS_MUTEX_C
#define _CAVERNPLUS_MUTEX_C

#ifdef CAVERN_USE_GLOBUS_THREADS
#include "globus_common.h"
#endif

#ifdef CAVERN_USE_PTHREADS
#include <pthread.h>
#endif

#ifdef CAVERN_USE_GLOBUS_THREADS
	#include "globus_common.h"
	typedef globus_mutex_t CAVERN_MUTEX_T;
#elif defined(CAVERN_USE_PTHREADS)
	#include <pthread.h>
	typedef pthread_mutex_t CAVERN_MUTEX_T;
#elif defined(CAVERN_USE_WINDOWSTHREADS)
	#include <windows.h>
	typedef HANDLE CAVERN_MUTEX_T;
#else
	#error One of CAVERN_USE_GLOBUS_THREADS, CAVERN_USE_PTHREADS, or CAVERN_USE_WINDOWSTHREADS must be defined.
#endif

/**
Mutual exclusion class.

This class encapsulates mutual exclusion in a C++ object.

*/
class CAVERNts_mutex_c {
public:

	enum mutexDebug_t {
		DEBUG_ON, DEBUG_OFF
	};

	/// Construct for a CAVERN mutual exclusion object.
	CAVERNts_mutex_c();

	/// Lock the mutex object.
	void lock();

	/// Unlock mutex object.
	void unlock();

	/// Turn mutex debug messages on or off.
	void setMutexDebug(CAVERNts_mutex_c::mutexDebug_t stat);

	/// Set the debug message to print whenever lock and unlock is performed.
	void setMutexDebugMesg(char *msg);

	/// Destructor for a CAVERN mutual exclusion object.
	~CAVERNts_mutex_c();

	/// Return the handle to the mutex variable.
	CAVERN_MUTEX_T * getMutex();

private:
	CAVERN_MUTEX_T mutex;
	mutexDebug_t debugStat;
	char *debugMsg;
};

#endif
