/******************************************************************
 * CAVERNsoft
 * Copyright (C) 1994-2002 Electronic Visualization Laboratory,
 * all rights reserved
 * By Jason Leigh, Yong-joo Cho, Naveen Krishnaprasad, Chris Scharver,
 * Stuart Bailey, Atul Nayak, Shalini Venkataraman, Joshua Eliason,
 * Javid Alimohideen 
 * University of Illinois at Chicago
 * 
 * This publication and its text and code may not be copied for commercial 
 * use without the express written permission of the University of Illinois
 * at Chicago.
 * The contributors disclaim any representation of warranty: use this
 * code at your own risk.
 * Direct questions, comments etc to cavern@evl.uic.edu
 ******************************************************************/

#ifndef _CAVERNPLUS_CAVERNPLUS_MCAST_CLASS
#define _CAVERNPLUS_CAVERNPLUS_MCAST_CLASS

#include "CAVERNnet_socketbase_c.hxx"

#ifdef __sgi 
extern int h_errno;
extern int errno;
#endif

/** Multicast Class. This class bypasses CAVERN's standard method for establishing connections and provides the user with direct control of multicast connections.
*/

class CAVERNnet_mcast_c : public CAVERNnet_socketbase_c {

public:

	//@{
	/// Status ok.
	static const int OK/* = 1*/;

	/// Status failed.
	static const int FAILED/* = 0*/;
	//@}

	static const int maxTTL;

	CAVERNnet_mcast_c();

	/// Close the connection
#ifdef WIN32
	void close()
		{::closesocket (sockfd);}
#else
	void close()
		{::close (sockfd);}
#endif
	/// Open a connection to the multicast IP address
	int init(char *mcastGroup, int port, int mttl = CAVERNnet_mcast_c::maxTTL);

	/// Broadcast a message to the group
	int send(char *, int);

	/// Receive a message from the group.
	int receive(char *, int);

	/// Print info on the current mcast connection.
	void printInfo();

	/// Tell mcast to use non-blocking data transfer.
	void makeNonBlocking();

	/// Get the IP address of the last message received
	unsigned long getReceiveIP();

	/// Same thing except it returns a string */
	void getReceiveIP(char *clientIP);

	/* Get the IP address of the mcast group. This shouldn't
	 * be anything you'd forget since you needed a number in the 1st
	 * place to start, but it's provided here for completeness.
	 */

	/// Accessor Functions
	//@{
	/// Get your own IP.
	unsigned long getSelfIP();
	/// Get your own IP.
	void getSelfIP(char *ip);
        /// Get outgoing packet's destination address.
	unsigned long getSendIP();
        /// Get outgoing packet's destination address.
	void getSendIP(char *ip);
        /// Get your own port.
	unsigned short getSelfPort();
        /// Get outgoing port.
	unsigned short getSendPort();
        /// Get incoming port.
	unsigned short getReceivePort();
	//@}

	/** Enable the logging of latency and inter-message delay.
	    Note: in order for this to work, all clients that subscribe to
	    the same multicast address must also enable their instrumentation or else
	    the bit stream will become confused. Enabling logging prepends timestamp
	    data that is used to compute latency. By default instrumentation
	    is disabled except for Bandwidth measurements.
	*/
	void enableInstrumentation();

	/** Disable the logging of latency and inter-message delay.
	    Note: in order for this to work, all clients that subscribe to
	    the same multicast address must also disable their instrumentation or else
	    the bit stream will become confused. By default instrumentation
	    is disabled except for Bandwith measurements.

	*/
	void disableInstrumentation();

private:

	int enableInstr;
	int sockfd;
	struct sockaddr_in receiveAddress, sendAddress;
	struct ip_mreq mreq;
	char ttl;

};
#endif
