/******************************************************************
 * CAVERNsoft
 * Copyright (C) 1994-2002 Electronic Visualization Laboratory,
 * all rights reserved
 * By Jason Leigh, Yong-joo Cho, Naveen Krishnaprasad, Chris Scharver,
 * Stuart Bailey, Atul Nayak, Shalini Venkataraman, Joshua Eliason,
 * Javid Alimohideen 
 * University of Illinois at Chicago
 * 
 * This publication and its text and code may not be copied for commercial 
 * use without the express written permission of the University of Illinois
 * at Chicago.
 * The contributors disclaim any representation of warranty: use this
 * code at your own risk.
 * Direct questions, comments etc to cavern@evl.uic.edu
 ******************************************************************/
// Turn this on to do in function tracing.
//#define CVRN_TRACE



#ifndef _CVRN_DEBUG
#define _CVRN_DEBUG


#define DBG_MEM 32
#define DBG_ERR 2
#define DBG_MSG 4
#define DBG_FAIL 8
#define DBG_REF 16
#define DBG_PUB 1
#define DBG_LOCK 64
#define DBG_THREAD 128

#define DBG_ALL (!0)
#ifdef CVRN_TRACE
	#ifdef WIN32
	#define cvrnTrace(prefix,mesg) 	EnterCriticalSection(&Win32StdioLock); printf("  cavern: "); if (prefix) {printf(prefix); printf(":");}  printf(mesg); printf("\n"); fflush(stdout); LeaveCriticalSection(&Win32StdioLock);
	#else
	#define cvrnTrace(prefix,mesg) 	nexus_stdio_lock(); printf("  cavern: "); if (prefix) {printf(prefix); printf(":");}  printf(mesg); printf("\n"); fflush(stdout); nexus_stdio_unlock();
	#endif
#else
#define cvrnTrace(prefix,mesg)
#endif


extern int _cvrnDebugLevel;
void cvrnSetDebugFilter(int);
void cvrnDebug(char* prefix, int lvl, char *fmt, ...);
void cvrnMesg(char *prefix, char *fmt, ...);

/**
A thread-safe printf. Use this rather than the standard printf to print
text to the TTY.

example 1:

cvrnPrintf("Hello %d %f", foo,bar);

prints something like:

Hello 123 32.4

@param fmt format string that you normally would have specified for
printf.
@param arguments for the format string.

*/
void cvrnPrintf(char *fmt, ...);




#endif
