/******************************************************************
 * CAVERNsoft
 * Copyright (C) 1994-2002 Electronic Visualization Laboratory,
 * all rights reserved
 * By Jason Leigh, Yong-joo Cho, Naveen Krishnaprasad, Chris Scharver,
 * Stuart Bailey, Atul Nayak, Shalini Venkataraman, Joshua Eliason,
 * Javid Alimohideen 
 * University of Illinois at Chicago
 * 
 * This publication and its text and code may not be copied for commercial 
 * use without the express written permission of the University of Illinois
 * at Chicago.
 * The contributors disclaim any representation of warranty: use this
 * code at your own risk.
 * Direct questions, comments etc to cavern@evl.uic.edu
 ******************************************************************/
#ifndef _CAVERN_INIT
#define _CAVERN_INIT

#ifdef WIN32
#include <windows.h>
#include <winsock.h>

extern CRITICAL_SECTION Win32StdioLock;
extern LARGE_INTEGER Frequency;
extern LARGE_INTEGER StartCounter;
extern struct timeval StartTimeVal;
extern int UseFTimeOnly;
#endif

#if defined(CAVERN_DO_NOT_USE_GLOBUS) && defined(CAVERN_USE_PTHREADS)
#include <pthread.h>

extern pthread_mutex_t pthread_stdio_lock;
#endif

/**
This is the first thing you do to start CAVERN. This initializes either Globus
or some other stuffs that must be initialized before calling any other CAVERN 
calls. Do not use any other CAVERN calls until you do this first.
*/
void CAVERNinit();

/**
Exit CAVERN when your application shuts down. This shuts down Globus.
*/
void CAVERNexit();

#endif
