/*****************************************************************************
 * Copyright  1994-1999 Macromedia, Inc.  All Rights Reserved
 *
 * You may utilize this source file to create and compile object code for use 
 * within products you create.  THIS CODE IS PROVIDED "AS IS", WITHOUT 
 * WARRANTY OF ANY KIND, AND MACROMEDIA DISCLAIMS ALL IMPLIED WARRANTIES 
 * INCLUDING, BUT NOT LIMITED TO, MERCHANTABILITY, FITNESS FOR A PARTICULAR 
 * PURPOSE AND NONINFRINGEMENT.  IN NO EVENT WILL MACROMEDIA BE LIABLE TO YOU 
 * FOR ANY CONSEQUENTIAL, INDIRECT OR INCIDENTAL DAMAGES ARISING OUT OF YOUR 
 * USE OR INABILITY TO USE THIS CODE.
 *
 *	Name: cscript.cpp
 *	
 * 	Purpose: Definitions of scripting class interface(s) and methods for the 
 *           Scripting Xtra skeleton project.
 *
 *
 *  HOW TO CUSTOMIZE THIS FILE
 *  --------------------------
 *  1. Save this file under a different file name.
 *  2. Use a search and replace utility (case sensitive) to replace the
 *     following:
 *
 *     Replace         With	
 *     -------         ----
 *     EZIOXtraScript      <this file name>
 *     EZIOXtraScript      <name of the class you defined>
 *
 *  3. Add and modify source code by looking for '--> insert -->' comment
 ****************************************************************************/ 

/*****************************************************************************
 *  INCLUDE FILE(S)
 *  ---------------
 *	This .cpp file should automatically include all the support files needed
 *	for this particular class. In addition, this file may include other .h
 *	files defining additional callback interfaces for use by a third party.   
 ****************************************************************************/ 
#ifndef _H_EZIOXtraScript
	#include "EZIOXtraScript.h"
#endif

#ifdef MACINTOSH
	#include <windows.h>
	#include <string.h>
#endif

/*****************************************************************************
 *  Private Methods
 *  -------------------
 *  Implementation of Private Class Methods
 ****************************************************************************/

/* ----------------------------------------------------- XScrpFindPorts */
MoaError EZIOXtraScript_IMoaMmXScript::XScrpFindPorts (PMoaDrCallInfo callPtr) 
{
	MoaError err = kMoaErr_NoErr;

#ifdef MACINTOSH
	short numOf;
	Str255 availPortNames="";
	int i;
 	GSXSerialPortNameRecordHandle portListH = nil;
	
	numOf = GSSerialOT::FindReadySerialPorts( &portListH, true );
	for (i=0;i<numOf;++i) {
		p2cstr( (*portListH)[i].userPortName );
		strcat ((char *)availPortNames,(const char *)(*portListH)[i].userPortName);
		strcat ((char *)availPortNames,"\r");
		
		
		c2pstr( (char *)(*portListH)[i].userPortName );
	}
	/*c2pstr((char *)availPortNames);*/
	pObj->pMmValue->StringToValue((const char *)availPortNames,&callPtr->resultValue);
#endif


#ifdef WINDOWS
	//This does not apply in Windows because they're always called COM1, COM2, etc.
	//returning empty string.
	pObj->pMmValue->StringToValue("",&callPtr->resultValue);
#endif


	return err;
}

/* ----------------------------------------------------- XScrpInitSerial */
MoaError EZIOXtraScript_IMoaMmXScript::XScrpInitSerial (PMoaDrCallInfo callPtr) 
{

	MoaError err = kMoaErr_NoErr;
#ifdef MACINTOSH
	OSErr Err = 0;

	short numOf;
	long int whichPort;	
	
	GSXSerialPortNameRecordHandle portListH = nil;
	GSXSerialPortNameRecord	portName;
	GSSerialPortInfoRecord	portInfo = { 57600, 8, kGSSerialParityNone, kGSSerialStopBits10 };
	numOf = GSSerialOT::FindReadySerialPorts( &portListH, true );
	
	pObj->pMmValue->ValueToInteger(& callPtr->pArgs[1], (long *)&whichPort);
	portName = (*portListH)[whichPort];
	pObj->port1 = new GSSerialOT( &portInfo, &portName );
	if ( pObj->port1 != nil ) {
		pObj->port1->InitSerialComm();
	}
	pObj->pMmValue->IntegerToValue (Err, &callPtr->resultValue);	
#endif

#ifdef WINDOWS
	//TODO
	MoaLong whichPort;	
	MoaChar comName[8];
	
	DCB dcbCommPort;

	pObj->pMmValue->ValueToInteger(&callPtr->pArgs[1], &whichPort);
	sprintf(comName,"COM%i",whichPort);
	pObj->port1 = CreateFile(comName,GENERIC_READ | GENERIC_WRITE,0,0,OPEN_EXISTING,0,0);
	if(pObj->port1!=INVALID_HANDLE_VALUE){

		// SET BAUD RATE, PARITY, WORD SIZE, AND STOP BITS.
		dcbCommPort.DCBlength = sizeof(DCB);
		GetCommState(pObj->port1, &dcbCommPort);
		BuildCommDCB("57600,N,8,1", &dcbCommPort);
		SetCommState(pObj->port1, &dcbCommPort);

		pObj->pMmValue->IntegerToValue (0, &callPtr->resultValue);
	}else{
		pObj->pMmValue->IntegerToValue (1, &callPtr->resultValue);
	}
#endif

	return err;
}

/* ----------------------------------------------------- XScrpReadLine */
MoaError EZIOXtraScript_IMoaMmXScript::XScrpReadLine (PMoaDrCallInfo callPtr) 
{
	MoaError err = kMoaErr_NoErr;

	long int lineNumInt;
	pObj->pMmValue->ValueToInteger(& callPtr->pArgs[1], (long *)&lineNumInt);
	lineNumInt--;

#ifdef MACINTOSH
	OSErr Err = 0;
	
	char outBuffer[2];
	unsigned char inChar=0;
	unsigned long count = 2L;
	
	outBuffer[0]='r';
	
	/* lines are 1-10 */
	outBuffer[1]=(char) lineNumInt;
	err=pObj->port1->SendSerialInfo((Ptr)outBuffer,count);
	if (!err) {
		count = 1;
		pObj->port1->GetSerialInfo( &inChar,&count,1);
	}
	pObj->pMmValue->IntegerToValue ((int)inChar,&callPtr->resultValue);
		
#endif

#ifdef WINDOWS
	DWORD dwBytesRead = 0;

	TransmitCommChar(pObj->port1, 'r');
	TransmitCommChar(pObj->port1, (char)lineNumInt);

	char inBuff;
	
	ReadFile(pObj->port1, (LPVOID)&inBuff, 1, &dwBytesRead, NULL);
	if(!dwBytesRead)inBuff=-1;
	pObj->pMmValue->IntegerToValue (inBuff,&callPtr->resultValue);
#endif


	return err;
}

/* ----------------------------------------------------- XScrpA2D */
MoaError EZIOXtraScript_IMoaMmXScript::XScrpA2D (PMoaDrCallInfo callPtr) 
{
	MoaError err = kMoaErr_NoErr;

	long int lineNumInt;
	pObj->pMmValue->ValueToInteger(& callPtr->pArgs[1], (long *)&lineNumInt);
	lineNumInt--;

#ifdef MACINTOSH
	OSErr Err = 0;
	
	char outBuffer[2];
	unsigned char inChar=0;
	unsigned long count =2;
	//long bytesAvail;
	char lineNum;
	
	/* lines are 1-10 */
	outBuffer[1] = (char) lineNumInt;
	outBuffer[0]='A';
	
	err=pObj->port1->SendSerialInfo((Ptr)outBuffer,count);
	if (!err) {
		count = 1;
		pObj->port1->GetSerialInfo( &inChar,&count,1);	

	}

	pObj->pMmValue->IntegerToValue ((unsigned int)inChar,&callPtr->resultValue);
#endif

#ifdef WINDOWS
	DWORD dwBytesRead = 0;

	TransmitCommChar(pObj->port1, 'A');
	TransmitCommChar(pObj->port1, (char)lineNumInt);

	char inBuff;
	ReadFile(pObj->port1, (LPVOID)&inBuff, 1, &dwBytesRead, NULL);
	if(!dwBytesRead)inBuff = -1;
	pObj->pMmValue->IntegerToValue (inBuff,&callPtr->resultValue);
#endif


	return err;
}

/* ----------------------------------------------------- XScrpWriteLine */
MoaError EZIOXtraScript_IMoaMmXScript::XScrpWriteLine (PMoaDrCallInfo callPtr) 
{
	MoaError err  = kMoaErr_NoErr;

	long int lineNumInt,stateInt;
	pObj->pMmValue->ValueToInteger(& callPtr->pArgs[1], (long *)&lineNumInt);
	pObj->pMmValue->ValueToInteger(& callPtr->pArgs[2], (long *)&stateInt);
	lineNumInt--;

#ifdef MACINTOSH
	OSErr Err = 0;
	char outBuffer[3];
	unsigned char inChar=0;
	unsigned long count = 3;
	//long bytesAvail;
	char lineNum,state;
	outBuffer[0]='w';
	outBuffer[1]=(char) lineNumInt;
	outBuffer[2]=(char) stateInt;
	
	err=pObj->port1->SendSerialInfo((Ptr)outBuffer,count);	
#endif

#ifdef WINDOWS
	TransmitCommChar(pObj->port1, 'w');
	TransmitCommChar(pObj->port1, (char)lineNumInt);
	TransmitCommChar(pObj->port1, (char)stateInt);
#endif

	return err;
}

/* ----------------------------------------------------- XScrpReadPort */
MoaError EZIOXtraScript_IMoaMmXScript::XScrpReadPort (PMoaDrCallInfo callPtr) 
{
	MoaError err = kMoaErr_NoErr;
#ifdef MACINTOSH
	OSErr Err = 0;
	
	
	char outBuffer[1];
	unsigned char inChar=0;
	unsigned long count = 1;
	
	outBuffer[0]='R';
	
	err=pObj->port1->SendSerialInfo((Ptr)outBuffer,count);	
	if (!err) {
		count = 1;
		pObj->port1->GetSerialInfo( &inChar,&count,1);	
	}
	pObj->pMmValue->IntegerToValue ((int)inChar,&callPtr->resultValue);
#endif

#ifdef WINDOWS
	DWORD dwBytesRead = 0;
	TransmitCommChar(pObj->port1, 'R');
	char inBuff;
	ReadFile(pObj->port1, (LPVOID)&inBuff, 1, &dwBytesRead, NULL);
	if(!dwBytesRead)inBuff = -1;
	pObj->pMmValue->IntegerToValue (inBuff,&callPtr->resultValue);
#endif

	return err;
}

/* ----------------------------------------------------- XScrpWritePort */
MoaError EZIOXtraScript_IMoaMmXScript::XScrpWritePort (PMoaDrCallInfo callPtr) 
{
	MoaError err = kMoaErr_NoErr;
	long int stateInt;
	pObj->pMmValue->ValueToInteger(& callPtr->pArgs[1], (long *)&stateInt);
#ifdef MACINTOSH
	OSErr Err = 0;
	char outBuffer[2];
	unsigned char inChar=0;
	unsigned long count = 2L;
	char state;
	outBuffer[0] = 'W';
	outBuffer[1] = (char) stateInt;
	err=pObj->port1->SendSerialInfo((Ptr)outBuffer,count);	
#endif

#ifdef WINDOWS
	TransmitCommChar(pObj->port1, 'W');
	TransmitCommChar(pObj->port1, (char)stateInt);
#endif

	return err;
}

/* ----------------------------------------------------- XScrpGetMagicNumber */
MoaError EZIOXtraScript_IMoaMmXScript::XScrpGetMagicNumber (PMoaDrCallInfo callPtr)
{
 	MoaError err = kMoaErr_NoErr;
 	int lineNum;
 	int foo;
 
 	pObj->pMmValue->ValueToInteger(& callPtr->pArgs[1], (long *)&lineNum);
 	pObj->pMmValue->ValueToInteger(& callPtr->pArgs[2], (long *)&foo);
 	pObj->pMmValue->IntegerToValue((pObj->theMagicNumber*100 + lineNum + foo), &callPtr->resultValue);
 	
 	return (err);
}

/*****************************************************************************
 *  CLASS INTERFACE(S)
 *  ------------------
 *  The interface(s) implemented by your MOA class are specified here.  Note
 *	that at least one class in your Xtra should implement the IMoaRegister
 *	interface.
 *  NOTE: Because C++ does not use a lpVtbl to reference an interface's
 *	methods, the actual method declaration is done in the .h file.
 *
 *  Syntax:
 *  BEGIN_DEFINE_CLASS_INTERFACE(<class-name>, <interface-name>) 
 ****************************************************************************/ 
BEGIN_DEFINE_CLASS_INTERFACE(EZIOXtraScript, IMoaMmXScript)
END_DEFINE_CLASS_INTERFACE

#ifdef USING_INIT_FROM_DICT
BEGIN_DEFINE_CLASS_INTERFACE(EZIOXtraScript, IMoaInitFromDict)
END_DEFINE_CLASS_INTERFACE
#endif

#ifdef USING_NOTIFICATION_CLIENT
BEGIN_DEFINE_CLASS_INTERFACE(EZIOXtraScript, IMoaNotificationClient)
END_DEFINE_CLASS_INTERFACE
#endif

/*
 * --> insert additional method(s) -->
 */
 
/*****************************************************************************
 *  CREATE AND DESTROY METHODS
 *  --------------------------
 *  Every interface and class has an associated 'Create' and 'Destroy' pair.
 *  'Create' methods are typically used to acquire interface(s), allocate 
 *  memory, and intialize variables. 'Destroy' methods are typically used to 
 *  release interfaces and free memory.
 *
 * NOTE:  In C++, the local variable 'This' is provided implicitly within 
 * a method implementation.  Thus, there is no need explicitly declare 'This' 
 * as a function parameter. However, this implementation detail doesnt apply 
 * to the MOA class creator and destructor functions, which are standard C 
 * functions, coded exactly as in like they are in C examples.  
 *
 * Class Syntax:
 * STDMETHODIMP MoaCreate_<class-name>(<class-name> FAR * This)
 * STDMETHODIMP MoaDestroy_<class-name>(<class-name> FAR * This)
 *
 * Interface Syntax:
 * <class_name>_<if_name>::<class_name>_<if_name>(MoaError FAR * pErr)
 * <class_name>_<if_name>::~<class_name>_<if_name>()
 ****************************************************************************/ 

/* ------------------------------------------------------ MoaCreate_EZIOXtraScript */
STDMETHODIMP MoaCreate_EZIOXtraScript(EZIOXtraScript FAR * This)
{
	
	/* variable declarations */
	MoaError err = kMoaErr_NoErr;
	
	This->pCallback->QueryInterface(&IID_IMoaMmValue, (PPMoaVoid)&This->pMmValue);
	This->theMagicNumber = 42;

#ifdef MACINTOSH
	This->port1 = nil;
#endif

#ifdef WINDOWS
	This->port1 = NULL;
#endif

	return(err);
}

/* ----------------------------------------------------- MoaDestroy_EZIOXtraScript */
STDMETHODIMP_(void) MoaDestroy_EZIOXtraScript(EZIOXtraScript FAR * This)
{
	/* free serial port */
	
#ifdef MACINTOSH
	This->port1->CloseSerialComm( );
#endif

#ifdef WINDOWS
	//TODO
	PurgeComm(This->port1, PURGE_RXABORT);
	//SetCommTimeouts(This->port1, &ctmoOld);
	CloseHandle(This->port1);
#endif

	// delete This->port1;
	
	if (This->pMmValue) This->pMmValue->Release();
	This->pMmValue = NULL;
	
	return;
}

/* ----------------------------------- EZIOXtraScript_IMoaMmXScript Create/Destroy */
EZIOXtraScript_IMoaMmXScript::EZIOXtraScript_IMoaMmXScript(MoaError FAR * pErr)
	{ *pErr = (kMoaErr_NoErr); }
EZIOXtraScript_IMoaMmXScript::~EZIOXtraScript_IMoaMmXScript() {}

#ifdef USING_INIT_FROM_DICT
/* -------------------------------- EZIOXtraScript_IMoaInitFromDict Create/Destroy */
EZIOXtraScript_IMoaInitFromDict::EZIOXtraScript_IMoaInitFromDict(MoaError FAR * pErr)
	{ *pErr = (kMoaErr_NoErr); }
EZIOXtraScript_IMoaInitFromDict::~EZIOXtraScript_IMoaInitFromDict() {}
#endif

#ifdef USING_NOTIFICATION_CLIENT
/* -------------------------- EZIOXtraScript_IMoaNotificationClient Create/Destroy */
EZIOXtraScript_IMoaNotificationClient::EZIOXtraScript_IMoaNotificationClient(MoaError FAR * pErr)
	{ *pErr = (kMoaErr_NoErr); }
EZIOXtraScript_IMoaNotificationClient::~EZIOXtraScript_IMoaNotificationClient() {}
#endif

/*
 * --> insert additional create/destroy method(s) -->
 */

/*****************************************************************************
 *  METHOD IMPLEMENTATION(S)
 *  ------------------------
 *  This is where the methods to be defined by your MOA class are implemented.
 *  The bulk of the work in implementing Xtras is done here.  NOTE: 'This' is 
 *  implemented implicitly in C++, therefore it isn't used in the argument-
 *	list.
 *
 *  Syntax:
 *  STDMETHODIMP <class-name>_<interface-name>::<method-name>(<argument-list>)
 ****************************************************************************/ 

/* -------------------------------------------- EZIOXtraScript_IMoaMmXScript::Call */
STDMETHODIMP EZIOXtraScript_IMoaMmXScript::Call(PMoaMmCallInfo callPtr)
{

	/* variable declarations */
	MoaError err = kMoaErr_NoErr;
	
	switch	( callPtr->methodSelector ) 
	{
		case m_new:
			/*
			 * --> insert additional code -->
		 	 */
			break;
		case m_findPorts:
			err = XScrpFindPorts (callPtr);
			break;
		case m_initSerial:
			err = XScrpInitSerial (callPtr);
			break;
		case m_readLine:
			err = XScrpReadLine (callPtr);
			break;
		case m_a2d:
			err = XScrpA2D (callPtr);
			break;
		case m_writeLine:
			err = XScrpWriteLine (callPtr);
			break;
		case m_readPort:
			err = XScrpReadPort (callPtr);
			break;
		case m_writePort:
			err = XScrpWritePort (callPtr);
			break;	
		case m_getMagicNumber:
			err = XScrpGetMagicNumber(callPtr);
			break;
		break;
		
		/*
		 * --> insert additional methodSelector cases -->
		 */
	}

	return(err);
}

#ifdef USING_INIT_FROM_DICT
/* --------------------------------- EZIOXtraScript_IMoaInitFromDict::InitFromDict */
STDMETHODIMP EZIOXtraScript_IMoaInitFromDict::InitFromDict(PIMoaRegistryEntryDict pRegistryDict)
{
	UNUSED(pRegistryDict);
	
	/* variable declarations */
	MoaError err = kMoaErr_NoErr;

	/*
	 *  --> insert additional code -->
	 */

	return(err);
}
#endif

#ifdef USING_NOTIFICATION_CLIENT
/* --------------------------------- EZIOXtraScript_IMoaNotificationClient::Notify */
STDMETHODIMP EZIOXtraScript_IMoaNotificationClient::Notify(ConstPMoaNotifyID nid, PMoaVoid pNData, PMoaVoid pRefCon)
{
	UNUSED(nid);
	UNUSED(pNData);
	UNUSED(pRefCon);
	
	/* variable declarations */
	MoaError err = kMoaErr_NoErr;

	/*
	 *  --> insert additional code -->
	 */

	return(err);
}
#endif

